<h2>Why is this an issue?</h2>
<p>A sparse array is an array in which the elements do not occupy a contiguous range of indices. In other words, there are gaps (or "holes") between
the elements in the array, where some indices have no corresponding value assigned to them.</p>
<p>Including an extra comma in an array literal signifies an empty slot in the array, thus creating a sparse array. An empty slot is not the same as a
slot filled with the <code>undefined</code> value. In some operations, empty slots behave as if they are filled with <code>undefined</code> but are
skipped in others.</p>
<p>While this is a well-defined behavior, it can be misleading and raises suspicions about the original intent: an extra comma was intentionally
inserted, or perhaps the developer meant to insert the missing value but forgot.</p>

```js
let a = [1, , 3, 6, 9]; // Noncompliant: Extra comma maybe denoting an oversight
```
<p>You should either remove the extra comma if this was a mistake or add the value you meant to insert initially.</p>

```js
let a = [1, 3, 6, 9];
```
<p>Alternatively, if the additional comma was intended, this should be made explicit with an <code>undefined</code> element.</p>

```js
let a = [1, undefined, 3, 6, 9];
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Indexed_collections#sparse_arrays">Sparse arrays</a>
  </li>
</ul>