<h2>Why is this an issue?</h2>
<p>In React, the <code>render</code> function is a required method in a class component that defines what will be rendered to the user interface (UI).
It is responsible for returning a value, typically a JSX (JavaScript XML) expression, that describes the structure and appearance of the component’s
UI.</p>
<p>When writing the <code>render</code> function in a component, it is easy to forget to return the JSX content, which means the component will render
nothing. Thus having a <code>render</code> function without a single <code>return</code> statement is usually a mistake.</p>

```js
const React = require('react');
class MyComponent extends React.Component {
  render() {
    <div>Contents</div>; // Noncompliant: The render function returns nothing
  }
}
```
<p>Make sure that the <code>render</code> function returns the JSX expression describing the structure and appearance of the component.</p>

```js
const React = require('react');
class MyComponent extends React.Component {
  render() {
    return <div>Contents</div>;
  }
}
```
<p>If it’s required that the component renders nothing, the <code>render</code> function should explicitly return <code>null</code>.</p>

```js
const React = require('react');
class MyComponent extends React.Component {
  render() {
    return null;
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/reference/react/Component">Component</a> </li>
  <li> React Documentation - <a href="https://react.dev/reference/react/Component#render"><code>render()</code></a> </li>
</ul>