<h2>Why is this an issue?</h2>
<p>React fragments are a feature in React that allows you to group multiple elements together without adding an extra DOM element. They are a way to
return multiple elements from a component’s render method without requiring a wrapping parent element.</p>
<p>However, a fragment is redundant if it contains only one child, or if it is the child of an HTML element.</p>

```js
<><Foo /></>;    // Noncompliant: The fragment has only one child
<p><>foo</></p>; // Noncompliant: The fragment is the child of the HTML element 'p'
```
<p>You can safely remove the redundant fragment while preserving the original behaviour.</p>

```js
<Foo />;
<p>foo</p>;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/reference/react/Fragment">Fragments</a> </li>
</ul>