<h2>Why is this an issue?</h2>
<p>The complexity of an expression is defined by the number of <code>&amp;&amp;</code>, <code>||</code> and <code>condition ? ifTrue : ifFalse</code>
operators it contains.</p>
<p>A single expression’s complexity should not become too high to keep the code readable.</p>
<h3>Noncompliant code example</h3>
<p>With the default threshold value of 3:</p>

```kotlin
if (((condition1 && condition2) || (condition3 && condition4)) && condition5) { ... }
```
<h3>Compliant solution</h3>

```kotlin
if ((myFirstCondition() || mySecondCondition()) && myLastCondition()) { ... }
```