<h2>Why is this an issue?</h2>
<p><code>if</code> statements with conditions that are always false have the effect of making blocks of code non-functional. <code>if</code>
statements with conditions that are always true are completely redundant, and make the code less readable.</p>
<p>There are three possible causes for the presence of such code:</p>
<ul>
  <li> An if statement was changed during debugging and that debug code has been committed. </li>
  <li> Some value was left unset. </li>
  <li> Some logic is not doing what the programmer thought it did. </li>
</ul>
<p>In any of these cases, unconditional <code>if</code> statements should be removed.</p>
<h3>Noncompliant code example</h3>

```kotlin
if (true) {
  doSomething()
}
...
if (false) {
  doSomethingElse()
}
```
<h3>Compliant solution</h3>

```kotlin
doSomething()
...
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://cwe.mitre.org/data/definitions/489">MITRE, CWE-489</a> - Active Debug Code </li>
  <li> <a href="https://cwe.mitre.org/data/definitions/570">MITRE, CWE-570</a> - Expression is Always False </li>
  <li> <a href="https://cwe.mitre.org/data/definitions/571">MITRE, CWE-571</a> - Expression is Always True </li>
</ul>