<h2>Why is this an issue?</h2>
<p>This rule applies whenever an <code>if</code> statement is followed by one or more <code>else if</code> statements; the final <code>else if</code>
should be followed by an <code>else</code> statement.</p>
<p>The requirement for a final <code>else</code> statement is defensive programming.</p>
<p>The <code>else</code> statement should either take appropriate action or contain a suitable comment as to why no action is taken. This is
consistent with the requirement to have a final <code>default</code> clause in a <code>switch</code> statement.</p>
<h3>Noncompliant code example</h3>

```kotlin
if (x == 0) {
  doSomething()
} else if (x == 1) {
  doSomethingElse()
}
```
<h3>Compliant solution</h3>

```kotlin
if (x == 0) {
  doSomething()
} else if (x == 1) {
  doSomethingElse()
} else {
  throw IllegalStateException()
}
```
<h3>Exceptions</h3>
<p>When all branches of an <code>if</code>-<code>else if</code> end with <code>return</code>, <code>break</code> or <code>throw</code>, the code that
comes after the <code>if</code> implicitly behaves as if it was in an <code>else</code> clause. This rule will therefore ignore that case.</p>