<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate efficiently.</p>
<p>This rule raises an issue when a function name does not match a provided regular expression.</p>
<p>For example, with the default provided regular expression <code>^[a-z][a-zA-Z0-9]*$</code>, the function:</p>

```php
function DoSomething(){ // Noncompliant
    // ...
}
```
<p>should be renamed to</p>

```php
function doSomething(){
    // ...
}
```
<p>In case the Drupal framework is detected and the default regex is not replaced, it will follow the PHP coding standards for Drupal.</p>

```php
function doSomething(){ // Noncompliant
    // ...
}
```
<p>should be renamed to</p>

```php
function do_something(){
    // ...
}
```
<h3>Exceptions</h3>
<p>Methods with an <code>@inheritdoc</code> annotation, as well as magic methods (<code>__construct()</code>, <code>__destruct()</code>,
<code>__call()</code>, <code>__callStatic()</code>, <code>__get()</code>, <code>__set()</code>, <code>__isset()</code>, <code>__unset()</code>,
<code>__sleep()</code>, <code>__wakeup()</code>, <code>__toString()</code>, <code>__invoke()</code>, <code>__set_state()</code>,
<code>__clone()</code>, <code>__debugInfo()</code>) are ignored.</p>

```php
function __construct(){...} // Compliant by exception
function __destruct(){...}  // Compliant by exception

/**
 * {@inheritdoc}
 */
function myFunc(){...}      // Compliant by exception
```
<h2>References</h2>
<ul>
  <li> <a href="https://www.drupal.org/docs/develop/standards/php/php-coding-standards#s-functions-and-variables">Drupal - Naming Conventions -
  Functions and variables</a> </li>
</ul>