<h2>Why is this an issue?</h2>
<p>Functions with a long parameter list are difficult to use because maintainers must figure out the role of each parameter and keep track of their
position.</p>

```php
function setCoordinates($x1, $y1, $z1, $x2, $y2, $z2) { // Noncompliant
    // ...
}
```
<p>The solution can be to:</p>
<ul>
  <li> Split the function into smaller ones </li>
</ul>

```php
// Each function does a part of what the original setCoordinates function was doing, so confusion risks are lower
function setOrigin(int $x, int $y, int $z) {
   // ...
}

function setSize(int $width, int $height, float $depth) {
   // ...
}
```
<ul>
  <li> Find a better data structure for the parameters that group data in a way that makes sense for the specific application domain </li>
</ul>

```php
class Point
{
    // In geometry, Point is a logical structure to group data
    public function __construct(
        public int $x,
        public int $y,
        public int $z
    ) {}
}

function setCoordinates(Point $p1, Point $p2) {
    // ...
}
```
<p>This rule raises an issue when a function has more parameters than the provided threshold.</p>