<h2>Why is this an issue?</h2>
<p>Empty statements represented by a semicolon <code>;</code> are statements that do not perform any operation. They are often the result of a typo or
a misunderstanding of the language syntax. It is a good practice to remove empty statements since they don’t add value and lead to confusion and
errors.</p>
<h3>Noncompliant code example</h3>

```php
function doSomething() {
  ;                                              // Noncompliant - was used as a kind of TODO marker
}

function doSomethingElse($p) {
  echo $p;;                                      // Noncompliant - double ;
}

for ($i = 1; $i <= 10; doSomething($i), $i++);   // Noncompliant - Rarely, they are used on purpose as the body of a loop. It is a bad practice to have side-effects outside of the loop body
```
<h3>Compliant solution</h3>

```php
function doSomething() {}

function doSomethingElse($p) {
  echo $p;

  for ($i = 1; $i <= 10; $i++) {
    doSomething($i);
  }
}
```