<p>This rule is deprecated, and will eventually be removed.</p>
<h2>Why is this an issue?</h2>
<p>Shadowing occurs when a local variable has the same name as a variable or a field in an outer scope.</p>
<p>This can lead to three main problems:</p>
<ul>
  <li> Confusion: The same name can refer to different variables in different parts of the scope, making the code hard to read and understand. </li>
  <li> Unintended Behavior: You might accidentally use the wrong variable, leading to hard-to-detect bugs. </li>
  <li> Maintenance Issues: If the inner variable is removed or renamed, the code’s behavior might change unexpectedly because the outer variable is
  now being used. </li>
</ul>
<p>To avoid these problems, rename the shadowing, shadowed, or both identifiers to accurately represent their purpose with unique and meaningful
names.</p>
<p>This rule focuses on variables in methods that shadow a field.</p>
<h3>Noncompliant code example</h3>

```php
class Foo {
  public $myField;

  public function doSomething() {
    $myField = 0; // Noncompliant
    ...
  }
}
```