<p>This rule raises an issue when a private function is never referenced in the code.</p>
<h2>Why is this an issue?</h2>
<p>A function that is never called is dead code, and should be removed. Cleaning out dead code decreases the size of the maintained codebase, making
it easier to understand the program and preventing bugs from being introduced.</p>
<p>This rule detects functions that are never referenced from inside a translation unit, and cannot be referenced from the outside.</p>
<p>It also raises on unused protected functions in PHP enumerations. In PHP enumerations private and protected are equivalent because inheritance is
not allowed.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
class Foo {
  private function __construct() {}   // Compliant, private empty constructor intentionally used to prevent any direct instantiation of a class.

  public static function doSomething() {
    $foo = new Foo();
    ...
  }

  private function unusedPrivateFunction() {}  // Noncompliant
}

enum ExampleEnum {
  case FIRST_CASE;

  private function unusedPrivateFunction() {} // Noncompliant
  protected function unusedProtectedFunction() {} // Noncompliant
}
```
<h4>Compliant solution</h4>

```php
class Foo {
  private function __construct() {}   // Compliant, private empty constructor intentionally used to prevent any direct instantiation of a class.

  public static function doSomething() {
    $foo = new Foo();
  }
}
```