<h2>Why is this an issue?</h2>
<p>When either the equality operator in a null test or the logical operator that follows it is reversed, the code has the appearance of safely
null-testing the object before dereferencing it. Unfortunately the effect is just the opposite - the object is null-tested and then dereferenced
<em>only</em> if it is null, leading to a guaranteed null pointer dereference.</p>
<h3>Noncompliant code example</h3>

```php
if ($obj == null && $obj->isOpen()) {
  echo "Object is open";
}

if ($obj != null || $obj->isOpen()) {
  echo "Object is not open";
}
```
<h3>Compliant solution</h3>

```php
if ($obj == null || $obj->isOpen()) {
  echo "Object is open";
}

if ($obj != null && !$obj->isOpen()) {
  echo "Object is not open";
}
```