<h2>Why is this an issue?</h2>
<p>The <code>var</code> keyword in PHP was historically used to declare class properties with default public visibility. However, its usage is
discouraged as it lacks clarity and explicit visibility declaration.</p>
<p>Instead, PHP introduced the keywords <code>public</code>, <code>protected</code>, and <code>private</code> to clearly define the visibility of
class properties. This enhances code readability and maintainability, as it becomes easier to understand and control access to class members.
Additionally, using the keywords for explicit visibility helps prevent unintended modifications or security vulnerabilities that may arise from the
ambiguity of the <code>var</code> keyword.</p>
<h3>Noncompliant code example</h3>

```php
<?php
class Foo
{
    var $bar = 1;
}
```
<h3>Compliant solution</h3>

```php
<?php
class Foo
{
    public $bar = 1;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/language.oop5.visibility.php">PHP Manual - Visibility</a> </li>
  <li> <a
  href="https://www.w3schools.com/php/keyword_var.asp#:~:text=The%20var%20keyword%20creates%20a,public%20should%20be%20used%20instead">W3Schools - var
  Keyword</a> </li>
</ul>