<h2>Why is this an issue?</h2>
<p>Global variables are a useful construct, but they should not be abused. Functions can access the global scope either through the
<code>global</code> keyword or though the <code>$GLOBALS</code> array, but these practices considerably reduce the function’s readability and
reusability. Instead, the global variable should be passed as a parameter to the function.</p>
<h3>Noncompliant code example</h3>

```php
$myGlobalVariable;

function foo()
{
  global $myGlobalVariable; // Noncompliant
  $GLOBALS['myGlobalVariable']; // Noncompliant
  // ...
}
```
<h3>Compliant solution</h3>

```php
function foo($myStateVariable)
{
  // ...
}
```