<h2>Why is this an issue?</h2>
<p>The repetition of a prefix operator (<code>!</code>, or <code>~</code>) is usually a typo. The second operator invalidates the first one:</p>

```php
$a = false;
$b = ~~$a; // Noncompliant: equivalent to "$a"
```
<p>While calling <code>!</code> twice is equivalent to calling the <code>boolval()</code> function, the latter increases the code readability, so it
should be preferred.</p>

```php
$a = 0;
$b = !!$a; // Noncompliant: equivalent to "boolval($a)"
```