<p>When accessing files on the local filesystem, PHP can enforce security checks to defend against some attacks. The <code>open_basedir</code> setting
in the main PHP configuration defines a set of directories that the application is allowed to access. Access to locations outside of these directories
will be blocked.</p>
<h2>Why is this an issue?</h2>
<p>The PHP runtime will allow the application to access all files underneath the configured set of directories. If no value is set, the application
may access any file on the filesystem.</p>
<h3>What is the potential impact?</h3>
<p><code>open_basedir</code> is commonly used to ensure that a PHP application can only access files needed for the application function. While
deactivating this setting does not pose a direct threat to the application’s security, it can make exploitation of other vulnerabilities easier and
more severe.</p>
<p>If an attacker can exploit a path traversal vulnerability, they will be able to access any file made available to the application’s user account.
This may include system-critical or otherwise sensitive files.</p>
<p>In shared hosting environments, a vulnerability can affect all co-hosted applications and not only the vulnerable one. <code>open_basedir</code>
can help limit the scope of the compromise in that case.</p>
<h2>How to fix it</h2>
<p>The main PHP configuration should define the <code>open_basedir</code> setting. This setting should not include overly large directories, such as
the root directory of the filesystem.</p>
<p>Adding the current directory, denoted by “.”, to the <code>open_basedir</code> configuration is also dangerous. It is possible to change the
current directory within PHP scripts by calling <code>chdir()</code>, effectively removing any protection.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
; php.ini
open_basedir="/:${USER}/scripts/data"  ; Noncompliant; root directory in the list
```

```php
; php.ini
; open_basedir= ; Noncompliant; setting commented out
```
<h4>Compliant solution</h4>

```php
; php.ini
open_basedir="${USER}/scripts/data"
```

```php
; php.ini try 1
open_basedir="/var/www/myapp/data"
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 Category A5 - Security Misconfiguration</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration">Top 10 2017 Category A6 - Security
  Misconfiguration</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/23">CWE-23 - Relative Path Traversal</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/36">CWE-36 - Absolute Path Traversal</a> </li>
</ul>