<h2>Why is this an issue?</h2>
<p><code>switch</code> can contain a <code>default</code> clause for various reasons: to handle unexpected values, to show that all the cases were
properly considered, etc.</p>
<p>For readability purposes, to help a developer quickly spot the default behavior of a <code>switch</code> statement, it is recommended to put the
<code>default</code> clause at the beginning or the end of the <code>switch</code> statement.</p>
<p>This rule raises an issue if the <code>default</code> clause is not the first or the last one of the <code>switch</code>'s cases.</p>

```php
switch ($param) {
  case 0:
    doSomething();
    break;
  default: // Noncompliant: default clause should be the first or last one
    error();
    break;
  case 1:
    doSomethingElse();
    break;
}
```