<h2>Why is this an issue?</h2>
<p>Sub-patterns can be wrapped by parentheses to build a group. This enables to restrict alternations, back reference the group or apply quantifier to
the sub-pattern.</p>
<p>If this group should not be part of the match result or if no reference to this group is required, a non-capturing group can be created by adding
<code>?:</code> behind the opening parenthesis.</p>
<p>However, if this non-capturing group does not have a quantifier, or does not wrap an alternation, then imaging this group is redundant.</p>
<h3>Noncompliant code example</h3>

```php
"(?:number)\d{2}"
```
<h3>Compliant solution</h3>

```php
"number\d{2}"
"(?:number)?\d{2}"
```
<h3>Exceptions</h3>
<p>This rule does not report an issue if the non-capturing group is an alternation.</p>

```php
"(?:number|string)"
```
<h2>Resources</h2>
<p><a href="https://www.php.net/manual/en/regexp.reference.subpatterns.php">Subpatterns</a> - PHP Documentation</p>