<p>In PHP, incorrect use of parentheses can cause unexpected behavior in code. Therefore, it is important to avoid the unnecessary usage of
parentheses for language constructs.</p>
<h2>Why is this an issue?</h2>
<p>Using constructs with parentheses can be misleading as it will produce a syntax that looks like a normal function call. However those constructs
have lower precedence in the evaluation order than some others operators, this can lead to a behavior completely different from what the function
syntax would hint. Also, some of the constructs have optional parameters, while modifying the code we may remove a parameter while keeping the
parentheses, resulting in invalid code.</p>
<h2>How to fix it</h2>
<p>When not necessary, do not use parentheses for the constructs. To be noted that some construct such as <code>isset()</code>, <code>exit()</code> or
<code>array()</code> does require them. Here is the list of constructs for which parentheses could be used but should be avoided :
<code>return</code>, <code>echo</code>, <code>break</code>, <code>clone</code>, <code>case</code>, <code>continue</code>, <code>include</code>,
<code>include_once</code>, <code>require</code>, <code>require_once</code>, <code>print</code>, <code>return</code>, <code>throw</code>,
<code>yield</code>, <code>yield from</code></p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
echo("Hello World");
return(1);
include("file.php");
```

```php
// Extra examples which show misleadings function syntax

// outputs "string" and "true"
// the expression ("string") && false is first evaluated to false, this is coerced to the empty string "" and printed
// the print construct returns 1 which is truthy, so code in the if block is run
if ( print("string") && false ) {
    print "true";
}

// parse error
return();

// parse error: 'echo' construct accepts multiple parameters, but with parentheses this is an invalid syntax
echo("Hello", "World");

// this does not include the file 'vars.php' because 'include' construct has lower precedence than the comparison
// first, ('vars.php') == TRUE is being evaluated and is resolved into '1'
// then, the include construct will be executed with this value
// this is equivalent to: include('1')
if (include('vars.php') == TRUE) {
    echo 'OK';
}
```
<h4>Compliant solution</h4>

```php
echo "Hello World";
return 1;
include "file.php";
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/reserved.keywords.php">PHP List of Keywords</a> </li>
</ul>