<h2>Why is this an issue?</h2>
<p>An empty method is generally considered bad practice and can lead to confusion, readability, and maintenance issues. Empty methods bring no
functionality and are misleading to others as they might think the method implementation fulfills a specific and identified requirement.</p>
<p>There are several reasons for a method not to have a body:</p>
<ul>
  <li> It is an unintentional omission, and should be fixed to prevent an unexpected behavior in production. </li>
  <li> It is not yet, or never will be, supported. In this case an exception should be thrown. </li>
  <li> The method is an intentionally-blank override. In this case a nested comment should explain the reason for the blank override. </li>
</ul>
<h3>Exceptions</h3>
<p>This does not raise an issue in the following cases:</p>
<ul>
  <li> Arrow functions as they can denote default values. </li>
  <li> Functions with a name starting with the prefix <code>on</code> like <code>onClick</code>. </li>
  <li> Functions whose name includes <code>noop</code>. </li>
  <li> Constructors as it is already covered by <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S6647'>javascript:S6647</a>. </li>
</ul>

```ts
static defaultProps = {
  listStyle: () => {}
};

function onClick() {
}

function myNoopFunction() {
}

class C {
  constructor() {}
}
```
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function shouldNotBeEmpty() {  // Noncompliant - method is empty
}

function notImplemented() {  // Noncompliant - method is empty
}

function emptyOnPurpose() {  // Noncompliant - method is empty
}
```
<h4>Compliant solution</h4>

```ts
function shouldNotBeEmpty() {
  doSomething();
}

function notImplemented() {
  throw new Error("notImplemented() cannot be performed because ...");
}

function emptyOnPurpose() {
  // comment explaining why the method is empty
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Functions">Functions</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S6647'>javascript:S6647</a> - Unnecessary constructors should be removed </li>
</ul>