<h2>Why is this an issue?</h2>
<p>In JavaScript, there are two types of comparison operators: strict and non-strict.</p>
<ul>
  <li> Strict operators: These operators compare both value and type. They are represented as <code>===</code> (strict equality) and <code>!==</code>
  (strict inequality). For example, <code>5 === "5"</code> would return <code>false</code> because, although the values are the same, the types are
  different (one is a number, the other is a string). </li>
  <li> Non-Strict operators: These operators compare only value, not type. They are represented as <code>==</code> (equality) and <code>!=</code>
  (inequality). For example, <code>5 == "5"</code> would return <code>true</code> because the values are the same, even though the types are
  different. </li>
</ul>
<p>It’s generally recommended to use strict operators in JavaScript to avoid unexpected results due to JavaScript’s type coercion. This is because
non-strict operators can lead to some counter-intuitive results. For example, <code>0 == false</code> would return <code>true</code>, which might not
be the expected outcome.</p>

```ts
function checkEqual(a, b) {
  if (a == b) { // Noncompliant: using non-strict equality '=='
    return "Equal";
  } else {
    return "Not equal";
  }
}

console.log(checkEqual(0, false)); // Output: "Equal"
```
<p>You should use the strict equality and inequality operators to prevent type coercion, avoid unexpected outcomes when comparing values of different
types, and provide more predictable results.</p>

```ts
function checkEqual(a, b) {
  if (a === b) {
    return "Equal";
  } else {
    return "Not equal";
  }
}

console.log(checkEqual(0, false)); // Output: "Not equal
```
<h3>Exceptions</h3>
<p>The rule does not report on these cases:</p>
<ul>
  <li> Comparing two literal values </li>
  <li> Evaluating the value of <code>typeof</code> </li>
  <li> Comparing against <code>null</code> </li>
</ul>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Strict_equality">Strict equality</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Strict_inequality">Strict inequality</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Equality">Equality</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Inequality">Inequality</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Type_coercion">Type coercion</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Truthy">Truthy</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Falsy">Falsy</a> </li>
</ul>