<h2>Why is this an issue?</h2>
<p>When the same code is duplicated in two or more separate branches of a conditional, it can make the code harder to understand, maintain, and can
potentially introduce bugs if one instance of the code is changed but others are not.</p>
<p>Having two <code>cases</code> in a <code>switch</code> statement or two branches in an <code>if</code> chain with the same implementation is at
best duplicate code, and at worst a coding error.</p>

```ts
if (a >= 0 && a < 10) {
  doFirstThing();
  doTheThing();
}
else if (a >= 10 && a < 20) {
  doTheOtherThing();
}
else if (a >= 20 && a < 50) {
  doFirstThing();
  doTheThing();  // Noncompliant; duplicates first condition
}
else {
  doTheRest();
}
```

```ts
switch (i) {
  case 1:
    doFirstThing();
    doSomething();
    break;
  case 2:
    doSomethingDifferent();
    break;
  case 3:  // Noncompliant; duplicates case 1's implementation
    doFirstThing();
    doSomething();
    break;
  default:
    doTheRest();
}
```
<p>If the same logic is truly needed for both instances, then:</p>
<ul>
  <li> in an <code>if</code> chain they should be combined </li>
</ul>

```ts
if ((a >= 0 && a < 10) || (a >= 20 && a < 50)) { // Compliant
  doFirstThing();
  doTheThing();
}
else if (a >= 10 && a < 20) {
  doTheOtherThing();
}
else {
  doTheRest();
}
```
<ul>
  <li> for a <code>switch</code>, one should fall through to the other </li>
</ul>

```ts
switch (i) {
  case 1:
  case 3: // Compliant
    doFirstThing();
    doSomething();
    break;
  case 2:
    doSomethingDifferent();
    break;
  default:
    doTheRest();
}
```
<p>When all blocks are identical, either this rule will trigger if there is no default clause or rule <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S3923'>javascript:S3923</a> will raise if there is a
default clause.</p>
<h3>Exceptions</h3>
<p>Unless all blocks are identical, blocks in an <code>if</code> chain that contain a single line of code are ignored. The same applies to blocks in a
<code>switch</code> statement that contains a single line of code with or without a following <code>break</code>.</p>

```ts
if (a == 1) {
  doSomething();  // Compliant, usually this is done on purpose to increase the readability
} else if (a == 2) {
  doSomethingElse();
} else {
  doSomething();
}
```
<h2>Resources</h2>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S3923'>javascript:S3923</a> - All branches in a conditional structure should not have exactly the same implementation </li>
</ul>