<h2>Why is this an issue?</h2>
<p>When exceptions occur, it is usually a bad idea to simply ignore them. Instead, it is better to handle them properly, or at least to log them.</p>
<h3>Noncompliant code example</h3>

```ts
function f() {
  try {
    doSomething();
  } catch (err) {
  }
}
```
<h3>Compliant solution</h3>

```ts
function f() {
  try {
    doSomething();
  } catch (err) {
    console.log(`Exception while doing something: ${err}`);
  }
}
```
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A09_2021-Security_Logging_and_Monitoring_Failures/">Top 10 2021 Category A9 - Security Logging and
  Monitoring Failures</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A10_2017-Insufficient_Logging%2526Monitoring">Top 10 2017 Category A10 -
  Insufficient Logging &amp; Monitoring</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/390">CWE-390 - Detection of Error Condition Without Action</a> </li>
</ul>