<h2>Why is this an issue?</h2>
<p>If the file upload feature is implemented without proper folder restriction, it will result in an implicit trust violation within the server, as
trusted files will be implicitly stored alongside third-party files that should be considered untrusted.</p>
<p>This can allow an attacker to disrupt the security of an internal server process or the running application.</p>
<h3>What is the potential impact?</h3>
<p>After discovering this vulnerability, attackers may attempt to upload as many different file types as possible, such as javascript files, bash
scripts, malware, or malicious configuration files targeting potential processes.</p>
<p>Below are some real-world scenarios that illustrate the potential impact of an attacker exploiting the vulnerability.</p>
<h4>Full application compromise</h4>
<p>In the worst-case scenario, the attackers succeed in uploading a file recognized by in an internal tool, triggering code execution.</p>
<p>Depending on the attacker, code execution can be used with different intentions:</p>
<ul>
  <li> Download the internal server’s data, most likely to sell it. </li>
  <li> Modify data, install malware, for instance, malware that mines cryptocurrencies. </li>
  <li> Stop services or exhaust resources, for instance, with fork bombs. </li>
</ul>
<h4>Server Resource Exhaustion</h4>
<p>By repeatedly uploading large files, an attacker can consume excessive server resources, resulting in a denial of service.</p>
<p>If the component affected by this vulnerability is not a bottleneck that acts as a single point of failure (SPOF) within the application, the
denial of service can only affect the attacker who caused it.</p>
<p>Even though a denial of service might have little direct impact, it can have secondary impact in architectures that use containers and container
orchestrators. For example, it can cause unexpected container failures or overuse of resources.</p>
<p>In some cases, it is also possible to force the product to "fail open" when resources are exhausted, which means that some security features are
disabled in an emergency.</p>
<p>These threats are particularly insidious if the attacked organization does not maintain a disaster recovery plan (DRP).</p>
<h2>How to fix it in Formidable</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
const Formidable = require('formidable');

const form          = new Formidable(); // Noncompliant
form.uploadDir      = "/tmp/";
form.keepExtensions = true;
```
<h4>Compliant solution</h4>

```ts
const Formidable = require('formidable');

const form          = new Formidable();
form.uploadDir      = "/uploads/";
form.keepExtensions = false;
```
<h3>How does this work?</h3>
<h4>Use pre-approved folders</h4>
<p>Create a special folder where untrusted data should be stored. This folder should be classified as untrusted and have the following
characteristics:</p>
<ul>
  <li> It should have specific read and write permissions that belong to the right people or organizations. </li>
  <li> It should have a size limit or its size should be monitored. </li>
  <li> It should contain backup copies if it contains data that belongs to users. </li>
</ul>
<p>This folder should not be located in <code>/tmp</code>, <code>/var/tmp</code> or in the Windows directory <code>%TEMP%</code>.<br> These folders
are usually "world-writable", can be manipulated, and can be accidentally deleted by the system.</p>
<p>Also, the original file names and extensions should be changed to controlled strings to prevent unwanted code from being executed based on the file
names.</p>
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A04_2021-Insecure_Design/">Top 10 2021 Category A4 - Insecure Design</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/434">CWE-434 - Unrestricted Upload of File with Dangerous Type</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/400">CWE-400 - Uncontrolled Resource Consumption</a> </li>
  <li> <a href="https://owasp.org/www-community/vulnerabilities/Unrestricted_File_Upload">OWASP Unrestricted File Upload</a> - Unrestricted File
  Upload </li>
</ul>