<h2>Why is this an issue?</h2>
<p>Having the same module imported multiple times can affect code readability and maintainability. It makes hard to identify which modules are being
used.</p>

```ts
import { B1 } from 'b';
import { B2 } from 'b'; // Noncompliant: there is already an import from module 'b'.
```
<p>Instead, one should consolidate the imports from the same module into a single statement. By consolidating all imports from the same module in a
single <code>import</code> statement, the code becomes more concise and easier to read, as there is only one import statement to keep track of.
Additionally, it can make it easier to identify which modules are used in the code.</p>

```ts
import { B1, B2 } from 'b';
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import"><code>import</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules">JavaScript modules</a> </li>
</ul>