<h2>Why is this an issue?</h2>
<p>In TypeScript, unions and intersections are used to combine multiple types into a single type, allowing you to create more flexible and powerful
type definitions.</p>
<ul>
  <li> A union type is represented using the pipe symbol <code>|</code>. It allows you to declare a variable or parameter that can hold values of
  different types. The variable can be assigned a value of any type listed in the union. </li>
  <li> An intersection type is represented using the ampersand symbol <code>&amp;</code>. It allows you to combine multiple types into a single type
  that includes all the properties and methods from each type. </li>
</ul>
<p>Having duplicated constituents in TypeScript unions and intersections can lead to undesirable behavior and potential issues in your code.
TypeScript’s type system aims to provide a strong and sound static type checking to catch errors during development and improve code reliability.
Including duplicate constituents in unions or intersections can make the type definitions unnecessarily verbose and redundant. This makes the code
harder to read and maintain.</p>

```ts
function padLeft(value: string, padding: string | number | string) { // Noncompliant: 'string' type is used twice in a union type declaration
  // ...
}

function extend(p : Person) : Person & Person & Loggable { // Noncompliant: 'Person' is used twice
 // ...
}
```
<p>Define unions and intersections with distinct and non-repeating constituents. This will make your code cleaner and more precise.</p>

```ts
function padLeft(value: string, padding: string | number | boolean) {
  // ...
}

function extend(p : Person) : Person & Loggable {
  // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/unions-and-intersections.html">Unions and Intersection
  Types</a> </li>
</ul>