<h2>Why is this an issue?</h2>
<p>A regular expression is a sequence of characters that specifies a match pattern in text. Among the most important concepts are:</p>
<ul>
  <li> Character classes: defines a set of characters, any one of which can occur in an input string for a match to succeed. </li>
  <li> Quantifiers: used to specify how many instances of a character, group, or character class must be present in the input for a match. </li>
  <li> Wildcard (<code>.</code>): matches all characters except line terminators (also matches them if the <code>s</code> flag is set). </li>
</ul>
<p>Many of these features include shortcuts of widely used expressions, so there is more than one way to construct a regular expression to achieve the
same results. For example, to match a two-digit number, one could write <code>[0-9]{2,2}</code> or <code>\d{2}</code>. The latter is not only shorter
but easier to read and thus to maintain.</p>
<p>This rule recommends replacing some quantifiers and character classes with more concise equivalents:</p>
<ul>
  <li> <code>\d</code> for <code>[0-9]</code> and <code>\D</code> for <code>[^0-9]</code> </li>
  <li> <code>\w</code> for <code>[A-Za-z0-9_]</code> and <code>\W</code> for <code>[^A-Za-z0-9_]</code> </li>
  <li> <code>.</code> for character classes matching everything (e.g. <code>[\w\W]</code>, <code>[\d\D]</code>, or <code>[\s\S]</code> with
  <code>s</code> flag) </li>
  <li> <code>x?</code> for <code>x{0,1}</code>, <code>x*</code> for <code>x{0,}</code>, <code>x+</code> for <code>x{1,}</code>, <code>x{N}</code> for
  <code>x{N,N}</code> </li>
</ul>

```ts
/a{1,}/;        // Noncompliant, '{1,}' quantifier is the same as '+'
/[A-Za-z0-9_]/; // Noncompliant, '\w' is equivalent
```
<p>Use the more concise version to make the regex expression more readable.</p>

```ts
/a+/;
/\w/;
```