<p>The usage of non-null assertion in front of assignments or comparators (<code>! =</code>, <code>! ==</code> or <code>! ===</code>) can be too
easily confused with a negative comparison.</p>
<p>The rule raises an issue when <code>! =</code>, <code>! ==</code> and <code>! ===</code> are used with a whitespace between the two operators.</p>
<h2>Why is this an issue?</h2>
<p>The usage of non-null assertion on the left-hand side of an assignment or comparison can be misread and produce unexpected results when one would
expect a negative comparator.</p>
<h2>How to fix it</h2>
<p>If you really meant to use the non-null assertion on the variable on which the issue is raised, you can simply move the non-null assertion to
another expression, or define a new one. Otherwise, if an extra whitespace slipped in the middle of a negative comparator, you can simply remove
it.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
let foo: number | undefined;
foo = bar! = 12; // Noncompliant; Is that really what's meant?
if (foo! == bar) { // Noncompliant; Is that really what's meant?
  // ...
}
if (foo! === bar) { // Noncompliant; Is that really what's meant?
  // ...
}
```
<h4>Compliant solution</h4>

```ts
let foo: number | undefined;
foo = bar = 12;
if (foo == bar) {
  // ...
}
if (foo === bar) {
  // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a
  href="https://www.typescriptlang.org/docs/handbook/2/everyday-types.html#non-null-assertion-operator-postfix-">Non-null Assertion Operator (Postfix
  <code>!</code>)</a> </li>
</ul>