<h2>Why is this an issue?</h2>
<p>The nullish coalescing operator <code>??</code> allows providing a default value when dealing with <code>null</code> or <code>undefined</code>. It
only coalesces when the original value is <code>null</code> or <code>undefined</code>. Therefore, it is safer and shorter than relying upon chaining
logical <code>||</code> expressions or testing against <code>null</code> or <code>undefined</code> explicitly.</p>
<p>This rule reports when disjunctions (<code>||</code>) and conditionals (<code>?</code>) can be safely replaced with coalescing
(<code>??</code>).</p>
<p>The TSConfig needs to set <code>strictNullChecks</code> to <code>true</code> for the rule to work properly.</p>
<h2>How to fix it</h2>
<p>Rewrite the logical expression <code>||</code> using <code>??</code> on the unchecked operands.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function either(x: number | undefined, y: number) {
  return x || y;
}
```
<h4>Compliant solution</h4>

```ts
function either(x: number | undefined, y: number) {
  return x ?? y;
}
```
<h4>Noncompliant code example</h4>

```ts
function either(x: number | undefined, y: number) {
  return x !== undefined ? x : y;
}
```
<h4>Compliant solution</h4>

```ts
function either(x: number | undefined, y: number) {
  return x ?? y;
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Nullish_coalescing">MDN - Nullish coalescing</a> </li>
</ul>