<h2>Why is this an issue?</h2>
<p>Not providing autocomplete values in form fields can lead to content inaccessibility. The function of each standard input field, which gathers a
person’s personal data, is systematically determined according to the list of <a href="https://www.w3.org/TR/WCAG21/#input-purposes">53 Input Purposes
for User Interface Components</a>. If the necessary autocomplete attribute values are absent, screen readers will not be able to identify and read
these fields. This lack of information can hinder users, particularly those using screen readers, from properly navigating and interacting with
forms.</p>
<p>For screen readers to operate effectively, it is imperative that the autocomplete attribute values are not only valid but also correctly
applied.</p>
<h2>How to fix it</h2>
<p>Ensure the autocomplete attribute is correct and suitable for the form field it is used with:</p>
<ul>
  <li> Identify the input type: The autocomplete attribute should be used with form elements like <code>&lt;input&gt;</code>,
  <code>&lt;select&gt;</code>, and <code>&lt;textarea&gt;</code>. The type of input field should be clearly identified using the <code>type</code>
  attribute, such as <code>type="text"</code>, <code>type="email"</code>, or <code>type="tel"</code>. </li>
  <li> Specify the autocomplete value: The value of the autocomplete attribute should be a string that specifies what kind of input the browser should
  autofill. For example, <code>autocomplete="name"</code> would suggest that the browser autofill the user’s full name. </li>
  <li> Use appropriate autocomplete values: The value you use should be appropriate for the type of input. For example, for a credit card field, you
  might use <code>autocomplete="cc-number"</code>. For a country field in an address form, you might use <code>autocomplete="country"</code>. </li>
</ul>
<p>For additional details, please refer to the <a
href="https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#attr-fe-autocomplete">guidelines</a> provided in the HTML standard.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function MyInput() {
    return <input type="text" autocomplete="foo" />; // Noncompliant
}
```
<h4>Compliant solution</h4>

```ts
function MyInput() {
    return <input type="text" autocomplete="name" />;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/identify-input-purpose">Identify Input Purpose</a> </li>
  <li> WCAG - <a href="https://www.w3.org/TR/WCAG21/#input-purposes">Input Purposes for User Interface Components</a> </li>
  <li> HTML Standard - <a href="https://html.spec.whatwg.org/multipage/forms.html#enabling-client-side-automatic-filling-of-form-controls">Enabling
  client-side automatic filling of form controls</a> </li>
  <li> HTML Standard - <a href="https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#attr-fe-autocomplete">Autofilling form
  controls: the autocomplete attribute</a> </li>
</ul>