<h2>Why is this an issue?</h2>
<p>In Node.js, it’s possible to import modules by specifying an absolute path, such as <code>/lib/foo/bar.js</code>. However, this approach can limit
the portability of your code, as it becomes tied to your computer’s file system. This could potentially lead to problems when the code is distributed,
for instance, via NPM packages. Therefore, it’s advisable to use relative paths or module names for importing modules to enhance the portability and
compatibility of your code across different systems.</p>
<h2>How to fix it</h2>
<p>Replace the absolute path with one that is relative to your current file.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
import { foo } from '/home/project/api/bar.js';
```
<h4>Compliant solution</h4>

```ts
import { foo } from '../api/bar.js';
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import">import</a> </li>
  <li> Node.js docs - <a href="https://nodejs.org/api/esm.html">ECMAScript modules</a> </li>
</ul>