# Anonymous Argument in Multiline Closure

Use named arguments in multiline closures

## Rationale

In multiline closures, for clarity, prefer using named arguments

```swift
closure { arg in
    print(arg)
}
```

to anonymous arguments

```swift
closure {
    print(↓$0)
}
```

## Non Triggering Examples

```swift
closure { $0 }
```

```swift
closure { print($0) }
```

```swift
closure { arg in
    print(arg)
}
```

```swift
closure { arg in
    nestedClosure { $0 + arg }
}
```

## Triggering Examples

```swift
closure {
    print(↓$0)
}
```