# Attribute Name Spacing

This rule prevents trailing spaces after attribute names, ensuring compatibility with Swift 6 where a space between an attribute name and the opening parenthesis results in a compilation error (e.g. `@MyPropertyWrapper ()`, `private (set)`).

## Non Triggering Examples

```swift
private(set) var foo: Bool = false
```

```swift
fileprivate(set) var foo: Bool = false
```

```swift
@MainActor class Foo {}
```

```swift
func funcWithEscapingClosure(_ x: @escaping () -> Int) {}
```

```swift
@available(*, deprecated)
```

```swift
@MyPropertyWrapper(param: 2) 
```

```swift
nonisolated(unsafe) var _value: X?
```

```swift
@testable import SwiftLintCore
```

```swift
func func_type_attribute_with_space(x: @convention(c) () -> Int) {}
```

```swift
@propertyWrapper
struct MyPropertyWrapper {
    var wrappedValue: Int = 1

    init(param: Int) {}
}
```

```swift
let closure2 = { @MainActor
  (a: Int, b: Int) in
}
```

## Triggering Examples

```swift
private ↓(set) var foo: Bool = false
```

```swift
fileprivate ↓(set) var foo: Bool = false
```

```swift
public ↓(set) var foo: Bool = false
```

```swift
  public  ↓(set) var foo: Bool = false
```

```swift
@ ↓MainActor class Foo {}
```

```swift
func funcWithEscapingClosure(_ x: @ ↓escaping () -> Int) {}
```

```swift
func funcWithEscapingClosure(_ x: @escaping↓() -> Int) {}
```

```swift
@available ↓(*, deprecated)
```

```swift
@MyPropertyWrapper ↓(param: 2) 
```

```swift
nonisolated ↓(unsafe) var _value: X?
```

```swift
@MyProperty ↓() class Foo {}
```

```swift
let closure1 = { @MainActor ↓(a, b) in
}
```