# Compiler Protocol Init

The initializers declared in compiler protocols such as `ExpressibleByArrayLiteral` shouldn't be called directly.

## Non Triggering Examples

```swift
let set: Set<Int> = [1, 2]
```

```swift
let set = Set(array)
```

## Triggering Examples

```swift
let set = ↓Set(arrayLiteral: 1, 2)
```

```swift
let set = ↓Set (arrayLiteral: 1, 2)
```

```swift
let set = ↓Set.init(arrayLiteral: 1, 2)
```

```swift
let set = ↓Set.init(arrayLiteral : 1, 2)
```