# Contains over Filter is Empty

Prefer `contains` over using `filter(where:).isEmpty`

## Non Triggering Examples

```swift
let result = myList.filter(where: { $0 % 2 == 0 }).count > 1
```

```swift
let result = myList.filter { $0 % 2 == 0 }.count > 1
```

```swift
let result = myList.filter(where: { $0 % 2 == 0 }).count == 1
```

```swift
let result = myList.filter { $0 % 2 == 0 }.count == 1
```

```swift
let result = myList.filter(where: { $0 % 2 == 0 }).count != 1
```

```swift
let result = myList.filter { $0 % 2 == 0 }.count != 1
```

```swift
let result = myList.contains(where: { $0 % 2 == 0 })
```

```swift
let result = !myList.contains(where: { $0 % 2 == 0 })
```

```swift
let result = myList.contains(10)
```

## Triggering Examples

```swift
let result = ↓myList.filter(where: { $0 % 2 == 0 }).isEmpty
```

```swift
let result = !↓myList.filter(where: { $0 % 2 == 0 }).isEmpty
```

```swift
let result = ↓myList.filter { $0 % 2 == 0 }.isEmpty
```

```swift
let result = ↓myList.filter(where: someFunction).isEmpty
```