# Contains over Range Comparison to Nil

Prefer `contains` over `range(of:) != nil` and `range(of:) == nil`

## Non Triggering Examples

```swift
let range = myString.range(of: "Test")
```

```swift
myString.contains("Test")
```

```swift
!myString.contains("Test")
```

```swift
resourceString.range(of: rule.regex, options: .regularExpression) != nil
```

## Triggering Examples

```swift
↓myString.range(of: "Test") != nil
```

```swift
↓myString.range(of: "Test") == nil
```