# Duplicate Imports

Imports should be unique

## Non Triggering Examples

```swift
import A
import B
import C
```

```swift
import A.B
import A.C
```

```swift
@_implementationOnly import A
@_implementationOnly import B
```

```swift
@testable import A
@testable import B
```

```swift
#if DEBUG
    @testable import KsApi
#else
    import KsApi
#endif
```

```swift
import A // module
import B // module
```

```swift
#if TEST
func test() {
}
```

```swift
import Foo
@testable import struct Foo.Bar
```

```swift
import CoreImage
import CoreImage.CIFilterBuiltins
```

## Triggering Examples

```swift
@_implementationOnly import A
↓@_implementationOnly import A

```

```swift
@testable import A
↓@testable import A

```

```swift
@testable import Foo
import struct Foo.Bar
```

```swift
import A
#if DEBUG
    @testable import KsApi
#else
    import KsApi
#endif
↓import A

```

```swift
import A
↓import class A.Foo

```

```swift
import A
↓import enum A.Foo

```

```swift
import A
↓import func A.Foo

```

```swift
import A
↓import let A.Foo

```

```swift
import A
↓import protocol A.Foo

```

```swift
import A
↓import struct A.Foo

```

```swift
import A
↓import typealias A.Foo

```

```swift
import A
↓import var A.Foo

```

```swift
import A.B
↓import A.B.C

```

```swift
import Foundation
import Dispatch
↓import Foundation

```

```swift
import Foundation
↓import Foundation
↓import Foundation

```

```swift
import Foundation
↓import Foundation.NSString

```

```swift
↓import A.B.C
import A.B

```

```swift
↓import Foundation.NSString
import Foundation

```