# Empty Count

Prefer checking `isEmpty` over comparing `count` to zero

## Non Triggering Examples

```swift
var count = 0
```

```swift
[Int]().isEmpty
```

```swift
[Int]().count > 1
```

```swift
[Int]().count == 1
```

```swift
[Int]().count == 0xff
```

```swift
[Int]().count == 0b01
```

```swift
[Int]().count == 0o07
```

```swift
discount == 0
```

```swift
order.discount == 0
```

```swift
let rule = #Rule(Tips.Event(id: "someTips")) { $0.donations.count == 0 }
```

```swift
func isEmpty(count: Int) -> Bool { count == 0 }
```

```swift
var isEmpty: Bool {
    let count = 0
    return count == 0
}
```

```swift
{ count in count == 0 }()
```

## Triggering Examples

```swift
[Int]().↓count == 0
```

```swift
0 == [Int]().↓count
```

```swift
[Int]().↓count==0
```

```swift
[Int]().↓count > 0
```

```swift
[Int]().↓count != 0
```

```swift
[Int]().↓count == 0x0
```

```swift
[Int]().↓count == 0x00_00
```

```swift
[Int]().↓count == 0b00
```

```swift
[Int]().↓count == 0o00
```

```swift
↓count == 0
```

```swift
#ExampleMacro { $0.list.↓count == 0 }
```