# Enum Case Associated Values Count

The number of associated values in an enum case should be low.

## Non Triggering Examples

```swift
enum Employee {
    case fullTime(name: String, retirement: Date, designation: String, contactNumber: Int)
    case partTime(name: String, age: Int, contractEndDate: Date)
}
```

```swift
enum Barcode {
    case upc(Int, Int, Int, Int)
}
```

## Triggering Examples

```swift
enum Employee {
    case ↓fullTime(name: String, retirement: Date, age: Int, designation: String, contactNumber: Int)
    case ↓partTime(name: String, contractEndDate: Date, age: Int, designation: String, contactNumber: Int)
}
```

```swift
enum Barcode {
    case ↓upc(Int, Int, Int, Int, Int, Int)
}
```