# Explicit Top Level ACL

Top-level declarations should specify Access Control Level keywords explicitly

## Non Triggering Examples

```swift
internal enum A {}
```

```swift
public final class B {}
```

```swift
private struct S1 {
    struct S2 {}
}
```

```swift
internal enum A { enum B {} }
```

```swift
internal final actor Foo {}
```

```swift
internal typealias Foo = Bar
```

```swift
internal func a() {}
```

```swift
extension A: Equatable {}
```

```swift
extension A {}
```

## Triggering Examples

```swift
↓enum A {}
```

```swift
final ↓class B {}
```

```swift
↓protocol P {}
```

```swift
↓func a() {}
```

```swift
internal let a = 0
↓func b() {}
```