# Final Test Case

Test cases should be final

## Non Triggering Examples

```swift
final class Test: XCTestCase {}
```

```swift
open class Test: XCTestCase {}
```

```swift
public final class Test: QuickSpec {}
```

```swift
class Test: MyTestCase {}
```

```swift
//
// test_parent_classes: ["MyTestCase", "QuickSpec", "XCTestCase"]
//

struct Test: MyTestCase {}

```

## Triggering Examples

```swift
class ↓Test: XCTestCase {}
```

```swift
public class ↓Test: QuickSpec {}
```

```swift
//
// test_parent_classes: ["MyTestCase", "QuickSpec", "XCTestCase"]
//

class ↓Test: MyTestCase {}

```