# Local Doc Comment

Prefer regular comments over doc comments in local scopes

## Non Triggering Examples

```swift
func foo() {
  // Local scope documentation should use normal comments.
  print("foo")
}
```

```swift
/// My great property
var myGreatProperty: String!
```

```swift
/// Look here for more info: https://github.com.
var myGreatProperty: String!
```

```swift
/// Look here for more info:
/// https://github.com.
var myGreatProperty: String!
```

## Triggering Examples

```swift
func foo() {
  ↓/// Docstring inside a function declaration
  print("foo")
}
```