# Non-optional String -> Data Conversion

Prefer non-optional `Data(_:)` initializer when converting `String` to `Data`

## Non Triggering Examples

```swift
Data("foo".utf8)
```

```swift
Data(string.utf8)
```

```swift
"foo".data(using: .ascii)
```

```swift
string.data(using: .unicode)
```

```swift
//
// include_variables: true
//

Data("foo".utf8)

```

```swift
//
// include_variables: true
//

Data(string.utf8)

```

```swift
//
// include_variables: true
//

"foo".data(using: .ascii)

```

```swift
//
// include_variables: true
//

string.data(using: .unicode)

```

## Triggering Examples

```swift
↓"foo".data(using: .utf8)
```

```swift
//
// include_variables: true
//

↓"foo".data(using: .utf8)

```

```swift
//
// include_variables: true
//

↓string.data(using: .utf8)

```

```swift
//
// include_variables: true
//

↓property.data(using: .utf8)

```

```swift
//
// include_variables: true
//

↓obj.property.data(using: .utf8)

```

```swift
//
// include_variables: true
//

↓getString().data(using: .utf8)

```

```swift
//
// include_variables: true
//

↓getValue()?.data(using: .utf8)

```