# Notification Center Detachment

An object should only remove itself as an observer in `deinit`

## Non Triggering Examples

```swift
class Foo {
   deinit {
       NotificationCenter.default.removeObserver(self)
   }
}
```

```swift
class Foo {
   func bar() {
       NotificationCenter.default.removeObserver(otherObject)
   }
}
```

## Triggering Examples

```swift
class Foo {
   func bar() {
       ↓NotificationCenter.default.removeObserver(self)
   }
}
```