# Optional Data -> String Conversion

Prefer failable `String(bytes:encoding:)` initializer when converting `Data` to `String`

## Non Triggering Examples

```swift
String(data: data, encoding: .utf8)
```

```swift
String(bytes: data, encoding: .utf8)
```

```swift
String(UTF8.self)
```

```swift
String(a, b, c, UTF8.self)
```

```swift
String(decoding: data, encoding: UTF8.self)
```

## Triggering Examples

```swift
String(decoding: data, as: UTF8.self)
```