# Prefer Self Type Over Type of Self

Prefer `Self` over `type(of: self)` when accessing properties or calling methods

## Non Triggering Examples

```swift
class Foo {
    func bar() {
        Self.baz()
    }
}
```

```swift
class Foo {
    func bar() {
        print(Self.baz)
    }
}
```

```swift
class A {
    func foo(param: B) {
        type(of: param).bar()
    }
}
```

```swift
class A {
    func foo() {
        print(type(of: self))
    }
}
```

## Triggering Examples

```swift
class Foo {
    func bar() {
        ↓type(of: self).baz()
    }
}
```

```swift
class Foo {
    func bar() {
        print(↓type(of: self).baz)
    }
}
```

```swift
class Foo {
    func bar() {
        print(↓Swift.type(of: self).baz)
    }
}
```