# Private over Fileprivate

Prefer `private` over `fileprivate` declarations

## Non Triggering Examples

```swift
extension String {}
```

```swift
private extension String {}
```

```swift
public protocol P {}
```

```swift
open extension 
 String {}
```

```swift
internal extension String {}
```

```swift
package typealias P = Int
```

```swift
extension String {
  fileprivate func Something(){}
}
```

```swift
class MyClass {
  fileprivate let myInt = 4
}
```

```swift
actor MyActor {
  fileprivate let myInt = 4
}
```

```swift
class MyClass {
  fileprivate(set) var myInt = 4
}
```

```swift
struct Outer {
  struct Inter {
    fileprivate struct Inner {}
  }
}
```

## Triggering Examples

```swift
↓fileprivate enum MyEnum {}
```

```swift
↓fileprivate class MyClass {
  fileprivate(set) var myInt = 4
}
```

```swift
↓fileprivate actor MyActor {
  fileprivate let myInt = 4
}
```

```swift
    ↓fileprivate func f() {}
    ↓fileprivate var x = 0
```