# Redundant Discardable Let

Prefer `_ = foo()` over `let _ = foo()` when discarding a result from a function

## Non Triggering Examples

```swift
_ = foo()
```

```swift
if let _ = foo() { }
```

```swift
guard let _ = foo() else { return }
```

```swift
let _: ExplicitType = foo()
```

```swift
while let _ = SplashStyle(rawValue: maxValue) { maxValue += 1 }
```

```swift
async let _ = await foo()
```

```swift
//
// ignore_swiftui_view_bodies: true
//

var body: some View {
    let _ = foo()
    return Text("Hello, World!")
}

```

```swift
//
// ignore_swiftui_view_bodies: true
//

@ViewBuilder
func bar() -> some View {
    let _ = foo()
    Text("Hello, World!")
}

```

```swift
//
// ignore_swiftui_view_bodies: true
//

#Preview {
    let _ = foo()
    Text("Hello, World!")
}

```

```swift
//
// ignore_swiftui_view_bodies: true
//

static var previews: some View {
    let _ = foo()
    Text("Hello, World!")
}

```

## Triggering Examples

```swift
↓let _ = foo()
```

```swift
if _ = foo() { ↓let _ = bar() }
```

```swift
var body: some View {
    ↓let _ = foo()
    Text("Hello, World!")
}
```

```swift
@ViewBuilder
func bar() -> some View {
    ↓let _ = foo()
    return Text("Hello, World!")
}
```

```swift
#Preview {
    ↓let _ = foo()
    return Text("Hello, World!")
}
```

```swift
static var previews: some View {
    ↓let _ = foo()
    Text("Hello, World!")
}
```