# Redundant Sendable

Sendable conformance is redundant on an actor-isolated type

## Non Triggering Examples

```swift
struct S: Sendable {}
```

```swift
class C: Sendable {}
```

```swift
actor A {}
```

```swift
@MainActor struct S {}
```

```swift
@MyActor enum E: Sendable { case a }
```

```swift
@MainActor protocol P: Sendable {}
```

## Triggering Examples

```swift
@MainActor struct ↓S: Sendable {}
```

```swift
actor ↓A: Sendable {}
```

```swift
//
// global_actors: ["MyActor"]
//

@MyActor enum ↓E: Sendable { case a }

```