# Self in Property Initialization

`self` refers to the unapplied `NSObject.self()` method, which is likely not expected; make the variable `lazy` to be able to refer to the current instance or use `ClassName.self`

## Non Triggering Examples

```swift
class View: UIView {
    let button: UIButton = {
        return UIButton()
    }()
}
```

```swift
class View: UIView {
    lazy var button: UIButton = {
        let button = UIButton()
        button.addTarget(self, action: #selector(didTapButton), for: .touchUpInside)
        return button
    }()
}
```

```swift
class View: UIView {
    var button: UIButton = {
        let button = UIButton()
        button.addTarget(otherObject, action: #selector(didTapButton), for: .touchUpInside)
        return button
    }()
}
```

```swift
class View: UIView {
    private let collectionView: UICollectionView = {
        let layout = UICollectionViewFlowLayout()
        let collectionView = UICollectionView(frame: .zero, collectionViewLayout: layout)
        collectionView.registerReusable(Cell.self)

        return collectionView
    }()
}
```

## Triggering Examples

```swift
class View: UIView {
    ↓var button: UIButton = {
        let button = UIButton()
        button.addTarget(self, action: #selector(didTapButton), for: .touchUpInside)
        return button
    }()
}
```

```swift
class View: UIView {
    ↓let button: UIButton = {
        let button = UIButton()
        button.addTarget(self, action: #selector(didTapButton), for: .touchUpInside)
        return button
    }()
}
```